/* FILE: ega.h                                  (D. Tottingham  07/25/89)
 *
 * Copyright (c), Symmetric Research, 1988
 *
 * This is a C include file of defines, data structures, and function
 * declarations for use with the EGA library functions.  Many of these
 * values are hardware specific and should not be changed from the values
 * listed here.
 *
 * HISTORY:
 * (08/10/88) -- Added color list.
 */

#ifndef _EGA_
#define _EGA_

/* Color Constants */
#define BLACK           0x00
#define BLUE            0x01
#define GREEN           0x02
#define CYAN            0x03
#define RED             0x04
#define MAGENTA         0x05
#define BROWN           0x06
#define LIGHT_WHITE     0x07
#define DARK_GREY       0x08
#define LIGHT_BLUE      0x09
#define LIGHT_GREEN     0x0A
#define LIGHT_CYAN      0x0B
#define LIGHT_RED       0x0C
#define LIGHT_MAGENTA   0x0D
#define YELLOW          0x0E
#define WHITE           0x0F

/* Defines for various set functions. */
#define ALPHA           0x03                    /* videomodes           */
#define MONO            0x0F
#define HIRES           0x10
#define REPLACE         0x00                    /* _func values         */
#define AND             0x08
#define OR              0x10
#define XOR             0x18
#define PLANES          0x00                    /* _mode values         */
#define PIXELS          0x02

extern int _mouse;                              /* current values       */
extern int _mapmask;
extern int _func;
extern int _mode;
extern int _bitmask;
/* extern int _enable;  */ /* Conflicts with MSC 5.1 */


/* Other useful constants. */
#define CHAR_HEIGHT     9                       /* character cell size  */
#define CHAR_WIDTH      8

#define MINI            0                       /* pixel ranges         */
#define MAXI            349
#define MINJ            0
#define MAXJ            639


/* Mouse defines and data structures. */
#define LEFT_BUTTON     0x01                    /* left button mask     */
#define RIGHT_BUTTON    0x02                    /* right button mask    */
typedef struct {
        int istart, jstart;                     /* initialized values   */
        int color;
        int iinc, jinc;
        int shift_iinc, shift_jinc;

        int i,j;                                /* returned data        */
        int i8x8, j8x8;
        int left, right;
        int key;
        }
        MOUSE_DATA;

/* Menu defines and data structures. */
typedef struct {
        int tag;                /* menu item identifier tag             */
        int key;                /* menu item keyboard key               */
        int i, j;               /* button coordinates                   */
        int frame;              /* button frame color                   */
        int on;                 /* on color                             */
        int off;                /* off color                            */
        char *s;                /* -> menu string                       */
        }
        MENU_DATA;


/* Function declarations. */
blt8x8( void far *, int, int, int, int);
bltdot( void far *, int, int, int, int);
bltdotw( void far *, int, int, int, int);
blticon( int far *, int, int, int);
plot( int, int, int far *, int, int);
plotmod( int, int, int far *, int far *, int, int, int);
/* read( int, int, int, int, int far *); */ /* Conflicts with MSC 5.1 */
set_palette( char far *);

#endif
